package easik.ui.tree.popup;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

import easik.Easik;
import easik.sketch.Sketch;
import easik.sketch.edge.SketchEdge;
import easik.sketch.path.SketchPath;
import easik.sketch.vertex.EntityNode;
import easik.states.LoadingState;

/**
 * Action for the rename entity option in the popup menu.
 * 
 * @author Kevin Green 2006
 * @version 2006-07-31 Kevin Green
 */
public class RenameEntityAction extends AbstractAction {
		
	/**
	 * Sets up rename entity action
	 */
	public RenameEntityAction( ) {		
		super("Rename Entity");	
		putValue(AbstractAction.MNEMONIC_KEY, new Integer(KeyEvent.VK_R));
		putValue(
			AbstractAction.SHORT_DESCRIPTION,
			"Change the name of selection");
	}
	
	/**
	 * Called when clicked upon, will rename an article. 
	 * 
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		//If there is nothing seleceted then just do nothing
		if(Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().isSelectionEmpty())
		{
			return;
		}
		
		//Get Sketch object
		Sketch _ourSketch = Easik.getInstance().getFrame().getSketch();
		
		//Get currently selected object
		DefaultMutableTreeNode curSelectedNode = (DefaultMutableTreeNode) 
					Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().getSelectionPath().getLastPathComponent();
		Object curSelected = curSelectedNode.getUserObject();
		
		EntityNode nodeToRename;
		String originalName = "";
		
		//Check what is currently selected
		if(curSelected instanceof EntityNode){
			nodeToRename = (EntityNode)curSelected;
			originalName = nodeToRename.getName();
		}
		else{
			return;
		}
			
		String s = (String)JOptionPane.showInputDialog(
							_ourSketch.getParent(),
							"New name:", "Rename",
							JOptionPane.QUESTION_MESSAGE,
							null, null, originalName);
		if (s != null) {
			s = s.trim();			
			if (s.equals("")){
				JOptionPane.showMessageDialog( Easik.getInstance().getFrame(),
						"Entity name is empty",
						"Error",
						JOptionPane.ERROR_MESSAGE);					
			}
			else if(_ourSketch.isNameUsed(s)){
				JOptionPane.showMessageDialog( Easik.getInstance().getFrame(),
						"Entity name is already in use",
						"Error",
						JOptionPane.ERROR_MESSAGE);
			}
			else{
				//Push loading state
				Easik.getInstance().getStateManager().pushState(new LoadingState());
				
				_ourSketch.getEntities().remove( nodeToRename.getName() );
				nodeToRename.setName( s );
				_ourSketch.getEntities().put( s, nodeToRename );
				
				Easik.getInstance().getFrame().getInfoTreeUI().refreshTree();
				Easik.getInstance().getFrame().getSketch().getGraphLayoutCache().reload();
				
				//Pop state
				Easik.getInstance().getStateManager().popState();
				
				_ourSketch.repaint();
				_ourSketch.setDirty(true);
			}		
		}	
		
		_ourSketch.getSelectionListener().emptySelection();
	}	
}
